/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.service.serviceaction.repair.effectors;

import com.ibm.hwmca.fw.service.managedsystem.ServiceableElement;
import com.ibm.hwmca.fw.service.managedsystem.fru.Fru;
import com.ibm.hwmca.fw.service.serviceableevent.ServiceableEvent;
import com.ibm.hwmca.fw.service.statetransition.Context;
import com.ibm.hwmca.fw.service.statetransition.Effector;
import com.ibm.hwmca.fw.service.statetransition.EffectorException;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.service.managedsystem.fru.DefaultFru;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ExchangeFrus
implements Effector {
    private static final String TRACE_MASKT = "XRVXEXFT";
    private static final String TRACE_MASKF = "XRVXEXFF";
    private static final String TRACE_MASKD = "XRVXEXFD";
    private static int[] EXCHANGE_SEQUENCE = new int[]{0, 1, 2, 3};

    public void fire(Context context) throws EffectorException {
        Trace.trace(TRACE_MASKT, "-> ExchangeFrus.fire");
        try {
            Map userData = context.getUserData();
            List fruList = (List)userData.get("SELECTED_FRUS");
            Iterator it = fruList.iterator();
            ServiceableEvent problem = (ServiceableEvent)userData.get("SERVICEABLE_EVENT");
            while (it.hasNext()) {
                ServiceableElement fru = (ServiceableElement)it.next();
                fru.prepare(userData);
                DefaultFru.buildAndDisplayCommonPanelSequence(fru, EXCHANGE_SEQUENCE, userData);
                if (fru instanceof Fru) {
                    ArrayList<ServiceableElement> exchangedFrus = (ArrayList<ServiceableElement>)userData.get("EXCHANGED_FRUS");
                    if (exchangedFrus == null) {
                        exchangedFrus = new ArrayList<ServiceableElement>();
                        userData.put("EXCHANGED_FRUS", exchangedFrus);
                    }
                    exchangedFrus.add(fru);
                }
                fru.getProperties().put("EXCHANGED", Boolean.TRUE);
                Trace.trace(TRACE_MASKF, "ExchangeFrus.fire exchanged FRU: " + fru);
                Trace.trace(TRACE_MASKF, "ExchangeFrus.fire exchanged FRU properties: " + fru.getProperties());
            }
            Trace.trace(TRACE_MASKT, "<- ExchangeFrus.fire");
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "<-! ExchangeFrus.fire, exception caught: " + e);
            Trace.trace(TRACE_MASKT, e);
            throw new EffectorException(e);
        }
    }
}

